/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY                          *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public Liense as published by        *
 * the Free Software Foundation, either version 2 of the License, or (at      * 
 * your option) any later version.                                            *
 *                                                                            *
 * The ITX package is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
 * for more details.                                                          * 
 *                                                                            *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.                                                   *
 *                                                                            * 
 * Contact information:                                                       *
 * Donna Bergmark                                                             *
 * 484 Rhodes Hall                                                            *
 * Cornell University                                                         *
 * Ithaca, NY 14853-3801                                                      *
 * bergmark@cs.cornell.edu                                                    *
 ******************************************************************************/
package shared;

import com.ms.wfc.app.*;

/**
 * This class can be used to retrieve all SPOT user settings.
 */
public class SPOTPreferences
{
	/**
	 * SPOT install directory
	 */
	private String mSPOTDirectory;
	
	/**
	 * SPOT directory service configuration file
	 */
	private String mSPOTDirectoryService;
	
	/**
	 * Class constructor.
	 */
	public SPOTPreferences()
	{
		// Get SPOT registry key
		RegistryKey key = Registry.CURRENT_USER;
		key = key.getSubKey("Software");
		key = key.getSubKey(SPOTDefinitions.SPOT_REGISTRY_KEY);
		
		// Get SPOT registry values
		if (key != null) {
			mSPOTDirectory = (String)key.getValue(SPOTDefinitions.SPOT_REGISTRY_DIRECTORY);
			mSPOTDirectoryService = (String)key.getValue(SPOTDefinitions.SPOT_REGISTRY_DS);
		}
	}
	
	/**
	 * Retrieves the current SPOT install directory
	 * 
	 * @return the current SPOT install directory
	 */
	public String getSPOTDirectory()
	{
		return mSPOTDirectory;
	}
	
	/**
	 * Retrieves the current SPOT directory service configuration file
	 * 
	 * @return the current SPOT directory service configuration file
	 */
	public String getSPOTDirectoryService()
	{
		return mSPOTDirectoryService;
	}
}
